{C 1996 Stellberg GmbH}
{ HISTORY OF CHANGES:  see CHANGES.PAS }
unit Isamexpt;

interface
   
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ToolIntf,
  ExptIntf, DB, DBTables;
                 
{$IFDEF VER90}
{$H-}
{$ENDIF}

type
  TIsamMainForm = class(TForm)
    StatusLine: TPanel;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Notebook1: TNotebook;
    GroupBox1: TGroupBox;
    CancelBttn: TBitBtn;
    Rueckbttn: TBitBtn;
    VorBttn: TBitBtn;
    GroupBox2: TGroupBox;
    EdiHauptCheck: TCheckBox;
    GroupBox4: TGroupBox;
    BrwHauptCheck: TCheckBox;
    FileopenBttn: TSpeedButton;
    GroupBox5: TGroupBox;
    Label7: TLabel;
    Label4: TLabel;
    Edit1: TEdit;
    SpeedButton1: TSpeedButton;
    Label6: TLabel;
    Edit3: TEdit;
    SpeedButton3: TSpeedButton;
    Label9: TLabel;
    DirInput: TEdit;
    SpeedButton4: TSpeedButton;
    Label10: TLabel;
    Label11: TLabel;
    IniDatNamInput: TEdit;
    IniBrwNamInput: TEdit;
    GroupBox6: TGroupBox;
    LabelNebenRadio: TRadioButton;
    LabelueberRadio: TRadioButton;
    GroupBox7: TGroupBox;
    LenFestRadio: TRadioButton;
    LenVarRadio: TRadioButton;
    EdiFontLabel: TLabel;
    EdiInputFontLabel: TLabel;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    FontDialog1: TFontDialog;
    SpeedButton7: TSpeedButton;
    LboxFontLabel: TLabel;
    Memo1: TMemo;
    GroupBox9: TGroupBox;
    Memo2: TMemo;
    GroupBox10: TGroupBox;
    Memo3: TMemo;
    Label2: TLabel;
    TableNameInput: TEdit;
    HelpBttn: TBitBtn;
    SprachBttn: TBitBtn;
    DateiBttn: TSpeedButton;
    OpenDialog2: TOpenDialog;
    EditorFormNameInput: TEdit;
    BrwFormNameInput: TEdit;
    Label1: TLabel;
    DBaseExpCheck: TCheckBox;
    DBaseImpCheck: TCheckBox;
    DBStruEdit: TEdit;
    Label5: TLabel;
    DBStruBttn: TSpeedButton;
    TblCreatCheck: TCheckBox;
    SaveTypBttn: TBitBtn;
    SaveDialog2: TSaveDialog;
    BrwSetupCheck: TCheckBox;
    AliasEdit: TComboBox;
    Label8: TLabel;
    Image1: TImage;
    GroupBox3: TGroupBox;
    GroupBox11: TGroupBox;
    Label12: TLabel;
    SpeedButton8: TSpeedButton;
    BrwProtoEdit: TEdit;
    BrwCheck: TCheckBox;
    BrwUpdCheck: TCheckBox;
    FrmBrwUpdCheck: TCheckBox;
    GroupBox12: TGroupBox;
    Label13: TLabel;
    SpeedButton9: TSpeedButton;
    EdiProtoEdit: TEdit;
    EdiCheck: TCheckBox;
    EdiUpdCheck: TCheckBox;
    FrmEdiUpdCheck: TCheckBox;
    GroupBox13: TGroupBox;
    StruCheck: TCheckBox;
    OpenDialog3: TOpenDialog;
    CodeTable: TTable;
    FrmTable: TTable;
    XLExpCheck: TCheckBox;
    Table1: TTable;
    Table2: TTable;
    GroupBox8: TGroupBox;
    ListBox1: TListBox;
    ListBox2: TListBox;
    BrwAllBttn: TSpeedButton;
    EdiAllBttn: TSpeedButton;
    UpdOldBtn: TBitBtn;
    BrwProcUpdCheck: TCheckBox;
    EdiProcUpdcheck: TCheckBox;
    AendernBttn: TSpeedButton;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FileopenBttnClick(Sender: TObject);
    procedure EndeBttnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EdiCheckClick(Sender: TObject);
    procedure CancelBttnClick(Sender: TObject);
    procedure RueckbttnClick(Sender: TObject);
    procedure VorBttnClick(Sender: TObject);
    procedure EdiHauptCheckClick(Sender: TObject);
    procedure BrwHauptCheckClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure Memo1Exit(Sender: TObject);
    procedure HelpBttnClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure SprachBttnClick(Sender: TObject);
    procedure DateiBttnClick(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure EditorFormNameInputExit(Sender: TObject);
    procedure BrwFormNameInputExit(Sender: TObject);
    procedure TableNameInputExit(Sender: TObject);
    procedure DirInputExit(Sender: TObject);
    procedure DBaseExpCheckClick(Sender: TObject);
    procedure DBaseImpCheckClick(Sender: TObject);
    procedure DBStruEditExit(Sender: TObject);
    procedure DBStruBttnClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure SaveTypBttnClick(Sender: TObject);
    procedure AliasEditClick(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure BrwCheckClick(Sender: TObject);
    procedure BrwUpdCheckClick(Sender: TObject);
    procedure EdiUpdCheckClick(Sender: TObject);
    procedure BrwAllBttnClick(Sender: TObject);
    procedure EdiAllBttnClick(Sender: TObject);
    procedure UpdOldBtnClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure BrwProcUpdCheckClick(Sender: TObject);
    procedure EdiProcUpdcheckClick(Sender: TObject);
    procedure AendernBttnClick(Sender: TObject);
    procedure SDBEditChange(Sender: TObject);
    procedure IDBEditChange(Sender: TObject);
    Private
      DrawBitmap: TBitmap;
      Sprache: Integer;
      TypDateiName: String;
      OrigEdiPas, OrigEdiFrm, OrigBrwPas, OrigBrwFrm: String;
      Procedure CheckButtons;
      Procedure FillListbox;
      function DoFormCreation(const FormIdent: string): TForm;
      function CreateEditorSource(const UnitIdent, FormIdent: string): TMemoryStream;
      function CreateEditorForm(const FormIdent: string): TMemoryStream;
      function DoBrwFormCreation(const FormIdent: string): TForm;
      function CreateBrowserForm(const FormIdent: string): TMemoryStream;
      function CreateBrowserSource(const UnitIdent, FormIdent,
                   EdiUnitIdent, EdiFormIdent: string): TMemoryStream;
      function CreateStru(Const FormIdent: String): TMemoryStream;
      Procedure Update_Listen(i: Integer);
      Procedure Setze_Sprache(S: Integer);
    Public
      RecList,KeyList,IIDList: TStringList;
      NeuerAendernBttn: Boolean;
  end;

{$IFDEF VER90}
{$H+}
{$ENDIF}

  TIsamDialogExpert = class(TIExpert)
  public  { Methods required by Delphi to define the expert }
    function GetName: string; override;
    function GetComment: string; override;
    function GetStyle: TExpertStyle; override;
    function GetState: TExpertState; override;
    function GetIDString: string; override;
    procedure Execute; override;
    {$IFDEF VER90}
    function GetGlyph: HICON; override;
    function GetAuthor: string; override;
    function GetPage: string; override;
    {$ELSE}
    function GetGlyph: HBITMAP; override;
    {$ENDIF}
  public
  private
  end;

implementation

Uses Proxies, IStreams, DirAusw, UToolDll, U_DbTool,
     WntIsam1, WntIsam2, WntIsam3, WntIsam4,
     VirtIntf, Inifiles, Upd_Stru, Wnt_Code;
                                            
{$R *.DFM}
{$IFDEF VER90}
{$R EXPTISAM.R32}
{$ELSE}
{$R EXPTISAM.R16}
{$ENDIF}
procedure HandleException;
begin
  ToolServices.RaiseException(ReleaseException);
end;

procedure WntvIsamDialogExpert(ToolServices: TIToolServices);
var
  D: TIsamMainForm;
  ISourceStream, IFormStream, IStruStream: TIMemoryStream;
  FormIdent, BrwIdent: string[79];
  {$IFDEF VER90}
  UnitIdent,FileName: String;
  {$ELSE}
  UnitIdent: String[79];
  FileName: TFileName;
  {$ENDIF}
  BrwUnitIdent, BrwFileName, StruIdent: String;
  UZahl,Code: Integer;
  StruFileName,UStr, Dir: String;
  IniFile : TIniFile;
begin
  if ToolServices = nil then Exit;
  if ToolServices.GetNewModuleName(UnitIdent, FileName) then
  begin
    D := TIsamMainForm.Create(Application);
    try
      D.Edit1.Text:= '';
      D.Edit3.Text:= '';
      Inifile:= TIniFile.Create('ISAMEXPT.INI');
      {Dir:= IniFile.ReadString('EXPERT','PATH','');}
      D.Sprache:= IniFile.ReadInteger('EXPERT','LANGUAGE',0);
      D.TblCreatCheck.Checked:= (IniFile.ReadInteger('EXPERT','CREATEBUTTON',0) = 1);
      D.BrwSetupCheck.Checked:= (IniFile.ReadInteger('EXPERT','SETUPBUTTON',0) = 1);
      D.DBaseExpCheck.Checked:= (IniFile.ReadInteger('EXPERT','DBASEEXPORT',0) = 1);
      D.DBaseImpCheck.Checked:= (IniFile.ReadInteger('EXPERT','DBASEIMPORT',0) = 1);
      D.BrwHauptCheck.Checked:= (IniFile.ReadInteger('EXPERT','BRWISMAIN',1) = 1);
      D.EdiHauptCheck.Checked:= (IniFile.ReadInteger('EXPERT','EDIISMAIN',0) = 1);
      D.EdiHauptCheck.Checked:= not(D.BrwHauptCheck.Checked);
      D.BrwCheck.Checked:= (IniFile.ReadInteger('EXPERT','CREATEBROWSER',1) = 1);
      D.EdiCheck.Checked:= (IniFile.ReadInteger('EXPERT','CREATEEDITOR',1) = 1);
      D.StruCheck.Checked:= (IniFile.ReadInteger('EXPERT','CREATESTRU',1) = 1);
      D.XLExpCheck.Checked:= (IniFile.ReadInteger('EXPERT','EXCELEXPORT',0) = 1);
      D.BrwProtoEdit.Text:= IniFile.ReadString('EXPERT','BRWPROTO','');
      D.EdiProtoEdit.Text:= IniFile.ReadString('EXPERT','EDIPROTO','');
      {D.AliasEdit.Text:= IniFile.ReadString('EXPERT','ALIAS','');}
      IniFile.Free;
      {D.DirInput.Text:= Dir;}
      if D.ShowModal = mrOK then begin
        Dir:= D.DirInput.Text;
        Inifile:= TIniFile.Create('ISAMEXPT.INI');
        IniFile.WriteString('EXPERT','PATH',Dir);
        IniFile.WriteInteger('EXPERT','LANGUAGE',D.Sprache);
        if D.TblCreatCheck.Checked then
          IniFile.WriteInteger('EXPERT','CREATEBUTTON',1)
        else
          IniFile.WriteInteger('EXPERT','CREATEBUTTON',0);
        if D.BrwSetupCheck.Checked then
          IniFile.WriteInteger('EXPERT','SETUPBUTTON',1)
        else
          IniFile.WriteInteger('EXPERT','SETUPBUTTON',0);
        if D.BrwHauptCheck.Checked then
          IniFile.WriteInteger('EXPERT','BRWISMAIN',1)
        else
          IniFile.WriteInteger('EXPERT','BRWISMAIN',0);
        if D.EdiHauptCheck.Checked then
          IniFile.WriteInteger('EXPERT','EDIISMAIN',1)
        else
          IniFile.WriteInteger('EXPERT','EDIISMAIN',0);
        if D.DBaseExpCheck.Checked then
          IniFile.WriteInteger('EXPERT','DBASEEXPORT',1)
        else
          IniFile.WriteInteger('EXPERT','DBASEEXPORT',0);
        if D.DBaseImpCheck.Checked then
          IniFile.WriteInteger('EXPERT','DBASEIMPORT',1)
        else
          IniFile.WriteInteger('EXPERT','DBASEIMPORT',0);
        if D.XLExpCheck.Checked then
          IniFile.WriteInteger('EXPERT','EXCELEXPORT',1)
        else
          IniFile.WriteInteger('EXPERT','EXCELEXPORT',0);
        if D.BrwCheck.Checked then
          IniFile.WriteInteger('EXPERT','CREATEBROWSER',1)
        else
          IniFile.WriteInteger('EXPERT','CREATEBROWSER',0);
        if D.EdiCheck.Checked then
          IniFile.WriteInteger('EXPERT','CREATEEDITOR',1)
        else
          IniFile.WriteInteger('EXPERT','CREATEEDITOR',0);
        if D.StruCheck.Checked then
          IniFile.WriteInteger('EXPERT','CREATESTRU',1)
        else
          IniFile.WriteInteger('EXPERT','CREATESTRU',0);
        IniFile.WriteString('EXPERT','BRWPROTO',D.BrwProtoEdit.Text);
        IniFile.WriteString('EXPERT','EDIPROTO',D.EdiProtoEdit.Text);
        {IniFile.WriteString('EXPERT','ALIAS',D.AliasEdit.Text);}
        IniFile.Free;
        UnitIdent:= D.Edit1.Text;
        if Pos('.',UnitIdent) > 0 then UnitIdent:= Copy(UnitIdent,1,Pos('.',UnitIdent)-1);
        FormIdent:= D.EditorFormNameInput.Text;
        if Pos('.',FormIdent) > 0 then FormIdent:= Copy(FormIdent,1,Pos('.',FormIdent)-1);
        BrwUnitIdent:= D.Edit3.Text;
        BrwIdent := D.BrwFormNameInput.Text;
        FileName:= Dir + UnitIdent + '.PAS';
        BrwFileName:= Dir + BrwUnitIdent + '.PAS';
        if (D.BrwCheck.Checked) or (D.BrwUpdCheck.Checked) or (D.FrmBrwUpdCheck.Checked)
        or (D.BrwProcUpdcheck.checked) then begin
          if ((D.BrwCheck.Checked) or (D.FrmBrwUpdCheck.Checked))
          and (D.BrwProcUpdCheck.Checked = False) then
          IFormStream := TIMemoryStream.Create(D.CreateBrowserForm(BrwIdent))
          else IFormStream:= NIL;
          try
            {$IFDEF VER90}
            if IFormStream <> NIL then IFormStream.AddRef;
            {$ENDIF}
            {if (D.BrwCheck.Checked) or (D.BrwUpdCheck.Checked) then}
            ISourceStream := TIMemoryStream.Create(D.CreateBrowserSource(BrwUnitIdent, BrwIdent,
                                                                         UnitIdent, FormIdent));
            {else ISourceStream:= NIL;}
            try
              {$IFDEF VER90}
              if ISourceStream <> NIL then ISourceStream.AddRef;
              {$ENDIF}
              ToolServices.CreateModule(BrwFileName, ISourceStream, IFormStream,
                [cmAddToProject, cmShowSource, cmShowForm, cmUnNamed,
                cmMarkModified]);
            finally
              if ISourceStream <> NIL then begin
                ISourceStream.OwnStream := True;
                ISourceStream.Free;
              end;
            end;
          finally
            if IFormStream <> NIL then begin
              IFormStream.OwnStream := True;
              IFormStream.Free;
            end;
          end;
        end;
        if (D.EdiCheck.Checked) or (D.EdiUpdCheck.Checked) or (D.FrmEdiUpdCheck.Checked)
        or (D.EdiProcUpdCheck.Checked) then begin
          if ((D.EdiCheck.Checked) or (D.FrmEdiUpdCheck.Checked))
          and (D.EdiProcUpdCheck.checked = False) then
          IFormStream := TIMemoryStream.Create(D.CreateEditorForm(FormIdent))
          else IFormStream:= NIL;
          try
            {$IFDEF VER90}
            if IFormStream <> NIL then IFormStream.AddRef;
            {$ENDIF}
            {if (D.EdiCheck.Checked) or (D.EdiUpdCheck.Checked) then}
            ISourceStream := TIMemoryStream.Create(D.CreateEditorSource(UnitIdent, FormIdent));
            {else ISourceStream:= NIL;}
            try
              {$IFDEF VER90}
              if ISourceStream <> NIL then ISourceStream.AddRef;
              {$ENDIF}
              ToolServices.CreateModule(FileName, ISourceStream, IFormStream,
                [cmAddToProject, cmShowSource, cmShowForm, cmUnNamed,
                cmMarkModified]);
            finally
              if ISourceStream <> NIL then begin
                ISourceStream.OwnStream := True;
                ISourceStream.Free;
              end;
            end;
          finally
            if IFormStream <> NIL then begin
              IFormStream.OwnStream := True;
              IFormStream.Free;
            end;
          end;
        end;
        if (D.StruCheck.Checked) and (D.DbStruEdit.Text <> '') then begin
          StruIdent:= D.DBStruEdit.Text;
          if Pos('.',StruIdent) > 0 then StruIdent:= Copy(StruIdent,1,Pos('.',StruIdent)-1);
          StruFileName:= Dir + StruIdent + '.PAS';
          IStruStream := TIMemoryStream.Create(D.CreateStru(StruIdent));
          try
            {$IFDEF VER90}
            IStruStream.AddRef;
            {$ENDIF}
            ToolServices.CreateModule(StruFileName, IStruStream, NIL,
              [cmAddToProject, cmShowSource, cmUnNamed, cmMarkModified]);
          finally
            IStruStream.OwnStream := True;
            IStruStream.Free;
          end;
        end;
      end;
    finally
      D.Free;
    end;
  end;
end;

{$IFDEF VER90}
{$H+}
{$ENDIF}

{ tIsamDialogExpert }
function tIsamDialogExpert.GetName: string;
begin
  try
    Result := 'ISAM_Expert';
  except
    HandleException;
  end;
end;

function tIsamDialogExpert.GetComment: string;
begin
  try
    Result := 'ISAM-Dialogexperte';
  except
    HandleException;
  end;
end;

{$IFDEF VER90}
function TIsamDialogExpert.GetGlyph: HICON;
begin
  try
    Result := LoadIcon(HInstance, 'IS_EXPT');
  except
    HandleException;
  end;
end;

function TIsamDialogExpert.GetAuthor: string;
begin
  try
    Result := 'N.Stellberg, K.Bertram';
  except
    HandleException;
  end;
end;

function TIsamDialogExpert.GetPage: string;
begin
  try
    Result := 'Dialoge';
  except
    HandleException;
  end;
end;
{$ELSE}
function tIsamDialogExpert.GetGlyph: HBITMAP;
begin
  try
    Result := LoadBitmap(HInstance, 'IS_EXPT');
  except
    HandleException;
  end;
end;
{$ENDIF}

function tIsamDialogExpert.GetStyle: TExpertStyle;
begin
  try
    Result := esForm;
  except
    HandleException;
  end;
end;

function tIsamDialogExpert.GetState: TExpertState;
begin
  try
    Result := [esEnabled];
  except
    HandleException;
  end;
end;

function tIsamDialogExpert.GetIDString: string;
begin
  try
    Result := 'ISAM_Expert';
  except
    HandleException;
  end;
end;

procedure tIsamDialogExpert.Execute;
begin
  try
    WntvIsamDialogExpert(ToolServices);
  except
    HandleException;
  end;
end;

{$IFDEF VER90}
{$H-}
{$ENDIF}

procedure TIsamMainForm.FormCreate(Sender: TObject);
var aktdir: string;
begin
  DrawBitmap := TBitmap.Create;
  Application.OnHint := ShowHint;
  AktDir:= ExtractFilePath(Application.ExeName);
  Check_Alias('ISAMEXP',AktDir);
  if Check_Tabelle(Self,CodeTable.DataBaseName,CodeTable,Upd_Struktur,False) = False
  then MessageDlg('Source-Tabelle konnte nicht erzeugt werden', mtError, [mbOk], 0)
  else CodeTable.Active:= True;
  if Check_Tabelle(Self,FrmTable.DataBaseName,FrmTable,WNT_FORM_PDXStruktur,False) = False
  then MessageDlg('Form-Tabelle konnte nicht erzeugt werden', mtError, [mbOk], 0)
  else FrmTable.Active:= True;
  CheckButtons;
  RecList:= TStringList.Create;
  KeyList:= TStringList.Create;
  IIDList:= TStringList.Create;
  Sprache:= 0;
  TypDateiName:= '';
  Session.GetAliasNames(AliasEdit.Items);
  OrigEdiPas:= '';
  OrigEdiFrm:= '';
  OrigBrwPas:= '';
  OrigBrwFrm:= '';
  NeuerAendernBttn:= True;
end;

procedure TIsamMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.Caption := Application.Hint;
end;

Procedure TIsamMainForm.FillListbox;
var S,BProto,EProto: String;
    BP,EP: TStringList;
    i: Integer;
    Impl: Boolean;
begin
  BProto:= BrwProtoEdit.Text;
  EProto:= EdiProtoEdit.Text;
  BP:= TStringList.Create;
  BP.LoadFromFile(BProto);
  Listbox1.Clear;
  if BP.Count > 0 then begin
    Impl:= False;
    for i:= 0 to BP.Count-1 do begin
      S:= BP[i];
      S:= UpperCase(S);
      if Pos('IMPLEMENTATION',S) > 0 then Impl:= true;
      if Pos('END.',S) > 0 then Impl:= False;
      if Impl then begin
        if (Pos('PROCEDURE',S) > 0) or (Pos('FUNCTION',S) > 0) then begin
          Listbox1.Items.Add(GetProcName(S));
        end;
      end;
    end;
  end;
  BP.Free;
  EP:= TStringList.Create;
  EP.LoadFromFile(EProto);
  Listbox2.Clear;
  if EP.Count > 0 then begin
    Impl:= False;
    for i:= 0 to EP.Count-1 do begin
      S:= EP[i];
      S:= UpperCase(S);
      if Pos('IMPLEMENTATION',S) > 0 then Impl:= true;
      if Pos('END.',S) > 0 then Impl:= False;
      if Impl then begin
        if (Pos('PROCEDURE',S) > 0) or (Pos('FUNCTION',S) > 0) then
        Listbox2.Items.Add(GetProcName(S));
      end;
    end;
  end;
  EP.Free;
end;

Procedure TIsamMainForm.CheckButtons;
var i: Integer;
    Dir: String;
begin
  i:= Notebook1.PageIndex;
  if I = 5 then begin
    SaveTypBttn.Visible:= True;
    UpdOldBtn.Visible:= True;
  end
  else begin
    SaveTypBttn.Visible:= False;
    UpdOldBtn.Visible:= False;
  end;
  RueckBttn.Enabled:= I > 0;
  if I = 0 then VorBttn.Enabled:= (Memo1.Lines.Count > 0)
  else if I = 1 then VorBttn.Enabled:= (Memo2.Lines.Count > 0) and (Memo3.Lines.Count > 0)
  else if I = 4 then VorBttn.Enabled:= (((DBStruEdit.Text <> '') and (AliasEdit.Text <> ''))
                                        or ((DBaseExpCheck.Checked = False) and (DbaseImpCheck.Checked = False)))
  else if I = 5 then VorBttn.Enabled:= ((BrwCheck.Checked) or (EdiCheck.Checked) or (StruCheck.Checked)
                                        or (EdiUpdCheck.Checked) or (FrmEdiUpdCheck.Checked)
                                        or (BrwUpdCheck.Checked) or (FrmBrwUpdCheck.Checked))
                                        and ((BrwProtoEdit.Text <> '') and (EdiProtoEdit.Text <> ''))
  else if I = 6 then VorBttn.Enabled:= ((BrwProcUpdCheck.Checked) and (Listbox1.Selcount > 0))
                                    or ((EdiProcUpdCheck.checked) and (Listbox2.SelCount > 0))
  else
    VorBttn.Enabled:= (DirInput.Text <> '') and
       (((Edit1.Text <> '') and (EditorFormNameInput.Text <> ''))
    or  ((Edit3.Text <> '') and (BrwFormNameInput.Text <> '')));
  if (DirInput.Text <> '') and ((Edit1.Text <> '') or (Edit3.Text <> '')) then begin
    Dir:= DirInput.Text;
    While Copy(Dir,Length(Dir),1) = '\' do Dir:= Copy(Dir,1,Length(Dir)-1);
    if (Edit1.Text <> '') then begin
      OrigEdiPas:= Dir + '\'+Edit1.Text+'.PAS';
      OrigEdiFrm:= Dir + '\'+Edit1.Text+'.DFM';
      if FileExists(OrigEdiPas) = False then begin
        EdiUpdCheck.Checked:= False;
        EdiUpdCheck.Enabled:= False;
      end
      else begin
        EdiUpdCheck.Enabled:= True;
      end;
      if FileExists(OrigEdiFrm) = False then begin
        FrmEdiUpdCheck.Checked:= False;
        FrmEdiUpdCheck.Enabled:= False;
      end
      else begin
        FrmEdiUpdCheck.Enabled:= True;
      end;
    end;
    if (Edit3.Text <> '') then begin
      OrigBrwPas:= Dir + '\'+Edit3.Text+'.PAS';
      OrigBrwFrm:= Dir + '\'+Edit3.Text+'.DFM';
      if FileExists(OrigBrwPas) = False then begin
        BrwUpdCheck.Checked:= False;
        BrwUpdCheck.Enabled:= False;
      end
      else begin
        BrwUpdCheck.Enabled:= True;
      end;
      if FileExists(OrigBrwFrm) = False then begin
        FrmBrwUpdCheck.Checked:= False;
        FrmBrwUpdCheck.Enabled:= False;
      end
      else begin
        FrmBrwUpdCheck.Enabled:= True;
      end;
    end;
    UpdOldBtn.Enabled:= (EdiUpdCheck.Enabled) or (BrwUpdcheck.Enabled);
  end;
  if VorBttn.Enabled then begin
    if I = 5 then FillListBox;
    if (I = 6) or (I = 5) then VorBttn.Caption:= '&Create'
    else begin
      if Sprache = 1 then Vorbttn.Caption:= '&Forward'
      else VorBttn.Caption:= '&Weiter';
    end;
    if I = 6 then begin
      BrwProcUpdcheck.Enabled:= BrwUpdCheck.Enabled;
      BrwAllBttn.Enabled:= BrwUpdCheck.Enabled;
      EdiProcUpdcheck.Enabled:= EdiUpdcheck.Enabled;
      EdiAllBttn.Enabled:= EdiUpdcheck.Enabled;
    end;
  end;
end;
{$IFDEF VER90}
{$H-}
{$ENDIF}

procedure TIsamMainForm.FileopenBttnClick(Sender: TObject);
var TypDatei:  TextFile;
    RecEinlesen,KeyEinlesen: Boolean;
    TypText,TText : String;
    Dir,RecordName,RStr: String;
begin
  if OpenDialog1.Execute then begin
    TypDateiName:= OpenDialog1.FileName;
    Memo1.Lines.Clear;
    KeyList.Clear;
    IIDList.Clear;
    AssignFile(TypDatei,TypDateiName);
    Reset(TypDatei);
    RecEinlesen:= False;
    KeyEinlesen:= False;
    RecordName:= '';
    Repeat
      ReadLn(TypDatei,TypText);
      TText:= UpperCase(TypText);
      Strip(TText);
      if Pos('{TABLENAME=',TText) > 0 then begin
        TText:= Copy(TText,12,Length(TText)-12);
        TableNameInput.Text:= TText;
      end
      else if Pos('{ALIASNAME=',TText) > 0 then begin
        TText:= Copy(TText,12,Length(TText)-12);
        AliasEdit.Text:= TText;
      end
      else if Pos('{EDITORFORMNAME=',TText) > 0 then begin
        TText:= Copy(TText,17,Length(TText)-17);
        EditorFormNameInput.Text:= TText;
      end
      else if Pos('{EDITORUNITNAME=',TText) > 0 then begin
        TText:= Copy(TText,17,Length(TText)-17);
        Edit1.Text:= TText;
      end
      else if Pos('{BROWSERFORMNAME=',TText) > 0 then begin
        TText:= Copy(TText,18,Length(TText)-18);
        BrwFormNameInput.Text:= TText;
      end
      else if Pos('{BROWSERUNITNAME=',TText) > 0 then begin
        TText:= Copy(TText,18,Length(TText)-18);
        Edit3.Text:= TText;
      end
      else if Pos('{STRUUNITNAME=',TText) > 0 then begin
        TText:= Copy(TText,15,Length(TText)-15);
        DBStruEdit.Text:= TText;
      end
      else if Pos('{DESTPATH=',TText) > 0 then begin
        Dir:= Copy(TText,11,Length(TText)-11);
        While Pos('{',Dir) > 0 do Delete(Dir,Pos('}',Dir),1);
        DirInput.Text:= DIR;
      end
      else begin
        if (Pos('TYPE',TText) > 0) or (Pos('=RECORD',TText) > 0) then RecEinlesen:= True;
        if (Pos('KEYBEGIN',TText) > 0) then KeyEinlesen:= True;
        if RecEinlesen then Memo1.Lines.Add(TypText);
        if KeyEinlesen then KeyList.Add(TypText);
        if Pos('END;',TText) > 0 then RecEinlesen:= False;
        if Pos('KEYEND',TText) > 0 then KeyEinlesen:= False;
        if (RecEinlesen) and (Pos('=RECORD',TText) > 0) then begin
          RStr:= Copy(TText,1,Pos('=RECORD',TText)-1);
          Strip(RStr);
          RecordName:= RStr;
          If Edit1.Text = '' then Edit1.Text:= Copy(RecordName,1,4)+'EDI';
          if Edit3.Text = '' then Edit3.Text:= Copy(RecordName,1,4)+'BRO';
          if EditorFormNameInput.Text = '' then EditorFormNameInput.Text:= Edit1.Text + 'DIALOG';
          if BrwFormNameInput.Text = '' then BrwFormNameInput.Text:= Edit3.Text + 'DIALOG';
          if DbStruEdit.Text = '' then DbStruEdit.Text:= Copy(RecordName,1,4)+'STRU';
        end;
      end;
    Until (Eof(TypDatei));
    CloseFile(TypDatei);
    If Memo1.Lines.Count < 1 then begin
      if Sprache = 1 then ErrorWindow('TYP-File has not the expected format','')
      else Errorwindow('Typ-Datei hat das falsche Format','');
    end;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.EndeBttnClick(Sender: TObject);
begin
  Close;
end;

procedure TIsamMainForm.FormDestroy(Sender: TObject);
begin
  RecList.Free;
  IIDList.Free;
  KeyList.Free;
  if FrmTable.Active then FrmTable.Close;
  if CodeTable.Active then CodeTable.Close;
  DrawBitmap.Free;
end;

function TIsamMainForm.DoFormCreation(const FormIdent: string): TForm;
begin
  if FrmEdiUpdCheck.Checked = False then OrigEdiFrm:= '';
  DoFormCreation:= Erzeuge_EditorForm(Self,
                                      FormIdent,RecList,
                                      LabelNebenRadio.Checked,
                                      LenFestRadio.Checked,
                                      EdiFontLabel.Font,
                                      EdiInputFontLabel.Font,
                                      Sprache);
end;

function TIsamMainForm.CreateEditorSource(const UnitIdent, FormIdent: string): TMemoryStream;
var EdiProto: String;
begin
  if ((FrmEdiUpdCheck.Checked) and (EdiUpdCheck.Checked = False)
  and (EdiProcUpdCheck.checked = False)) then begin
    {Wenn nur Formupdate, dann wird Source neu geladen}
    Result:= TMemoryStream.Create;
    Try
      Result.LoadFromFile(OrigEdiPas);
    Except
      Result.Free;
      Raise;
    end;
  end
  else begin
    EdiProto:= EdiProtoEdit.Text;
    if (EdiUpdCheck.Checked = False) and (EdiProcUpdcheck.Checked = False) then OrigEdiPas:= '';
    CreateEditorSource:= Erzeuge_EditorSource(UnitIdent, FormIdent,
                                      Self, Sprache,TypDateiName,
                                      EdiProto, OrigEdiPas);
  end;
end;

function TIsamMainForm.CreateEditorForm(const FormIdent: string): TMemoryStream;
var DlgForm: TForm;
begin
  Result := nil;
  DlgForm := DoFormCreation(FormIdent);
  try
    Result := TMemoryStream.Create;
    Result.WriteComponentRes(FormIdent, DlgForm);
    Result.Position:= 0;
    if OrigEdiFrm <> '' then AltForm_Verwerten(Result, OrigEdiFrm, FrmTable);
    Result.Position := 0;
  finally
    DlgForm.Free;
  end;
end;

function TIsamMainForm.DoBrwFormCreation(const FormIdent: string): TForm;
var TblNam: String;
begin
  TblNam:= TableNameInput.Text;
  if Pos('.',TblNam) > 0 then TblNam:= Copy(TblNam,1,Pos('.',TblNam)-1);
  if FrmBrwUpdCheck.Checked = False then OrigBrwFrm:= '';
  DoBrwFormCreation:= Erzeuge_BrowserForm(FormIdent,
                                          TblNam,
                                          IniDatNamInput.Text,
                                          IniBrwNamInput.Text,
                                          LboxFontLabel.Font,
                                          IIDList,KeyList,RecList,
                                          DbaseExpCheck.Checked,
                                          DBaseImpCheck.Checked,
                                          XLExpCheck.Checked,
                                          Sprache,
                                          TblCreatCheck.Checked,
                                          BrwSetupCheck.Checked);
end;

function TIsamMainForm.CreateBrowserForm(const FormIdent: string): TMemoryStream;
var DlgForm: TForm;
begin
  Result := nil;
  DlgForm := DoBrwFormCreation(FormIdent);
  try
    Result := TMemoryStream.Create;
    Result.WriteComponentRes(FormIdent, DlgForm);
    Result.Position:= 0;
    if OrigBrwFrm <> '' then begin
      AltForm_Verwerten(Result, OrigBrwFrm, FrmTable);
      {Result.WriteComponentRes(FormIdent,DlgForm);}
    end;
    Result.Position := 0;
  finally
    DlgForm.Free;
  end;
end;

function TIsamMainForm.CreateBrowserSource(const UnitIdent, FormIdent,
  EdiUnitIdent, EdiFormIdent: string): TMemoryStream;
begin
  if ((FrmBrwUpdCheck.Checked) and (BrwUpdCheck.Checked = False)
  and (BrwProcUpdCheck.checked = False)) then begin
    {Wenn nur Formupdate, dann wird Source neu geladen
    ebenso beim Prozeduren-Update}
    Result:= TMemoryStream.Create;
    Try
      Result.LoadFromFile(OrigBrwPas);
    Except
      Result.Free;
      Raise;
    end;
  end
  else begin 
    if (BrwUpdCheck.Checked = False) and (BrwProcUpdCheck.checked = False) then OrigBrwPas:= '';
    CreateBrowserSource:= Erzeuge_BrowserSource(UnitIdent, FormIdent,
                                   EdiUnitIdent, EdiFormIdent,
                                   Self,
                                   Sprache,
                                   TypDateiName,
                                   OrigBrwPas);
  end;
end;

function TIsamMainForm.CreateStru(Const FormIdent: String): TMemoryStream;
begin
  CreateStru:= Erzeuge_Struktur(FormIdent,RecList,KeyList);
end;

procedure TIsamMainForm.EdiCheckClick(Sender: TObject);
begin
  if EdiCheck.Checked then begin
    EdiUpdCheck.Checked:= False;
    FrmEdiUpdcheck.Checked:= False;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.CancelBttnClick(Sender: TObject);
begin
  ModalResult:= mrCancel;
end;

procedure TIsamMainForm.RueckbttnClick(Sender: TObject);
var i: Integer;
begin
  i:= Notebook1.PageIndex;
  Case I of
    6: begin
         i:= 5;
         BrwProcUpdCheck.Checked:= False;
         EdiProcUpdCheck.Checked:= False;
       end;
    5: i:= 4;
    4: i:= 3;
    3: i:= 2;
    2: begin
         Update_Listen(2);
         I:= 1;
       end;
    1: begin
         Update_Listen(1);
         i:= 0;
       end;
    else i:= 0;
  end;
  Notebook1.PageIndex:= i;
  CheckButtons;
end;

Procedure Check_KeyList(S: String; KList: TStringList);
var ZStr,KStr: String;
    K,KeyLen,xPos,idx,Code: Integer;
    Gefunden,DupKey: Boolean;
begin
  ZStr:= S;
  Idx:= 0;
  xPos:= Pos('[',ZStr);
  if xPos > 0 then begin
    Delete(ZStr,1,xPos);
    xPos:= Pos(']',ZStr);
    if xPos > 0 then begin
      ZStr:= Copy(ZStr,1,xPos-1);
      Strip(ZStr);
      Val(ZStr,idx,Code);
    end;
  end;
  if idx > 0 then begin
    K:= 0;
    Gefunden:= False;
    While (K < KList.Count) and (Gefunden = False) do begin
      KStr:= KList[K];
      Strip(KStr);
      if Pos('{KEYNO='+DezStr(idx),KStr) > 0 then Gefunden:= True
      else Inc(K);
    end;
    if Gefunden then begin
      KeyLen:= 0;
      ZStr:= UpperCase(S);
      Strip(ZStr);
      xPos:= Pos('KEYL:=',ZStr);
      if xPos > 0 then begin
        Delete(ZStr,1,xPos + 5);
        xPos:= Pos(';',ZStr);
        if xPos > 0 then begin
          ZStr:= Copy(ZStr,1,xPos-1);
          Strip(ZStr);
          Val(ZStr,KeyLen,Code);
        end;
      end;
      KStr:= KList[K];
      xPos:= Pos('{KEYLEN=',KStr);
      if xPos > 0 then begin
        Delete(KStr,xPos,7);
        While (Length(KStr) > xPos) and (KStr[xPos] <> '}') do Delete(KStr,xPos,1);
        if KStr[xPos] = '}' then Delete(KStr,xPos,1);
      end;
      KStr:= KStr + '{KEYLEN='+DezStr(KeyLen)+'}';
      ZStr:= UpperCase(S);
      DupKey:= (Pos('TRUE',ZStr) > 0);
      xPos:= Pos('{DUPKEY=',KStr);
      if xPos > 0 then begin
        Delete(KStr,xPos,8);
        While (Length(KStr) > xPos) and (KStr[xPos] <> '}') do Delete(KStr,xPos,1);
        if KStr[xPos] = '}' then Delete(KStr,xPos,1);
      end;
      if DupKey then KStr:= KStr + '{DUPKEY=TRUE}'
      else KStr:= KStr + '{DUPKEY=FALSE}';
      KList[idx]:= KStr;
    end;
  end;
end;

Procedure TIsamMainForm.Update_Listen(i: Integer);
var L,x,IdxAnzahl,Code,xPos      : Integer;
    ListText,LText,IStr,LStr,KStr: String;
begin
  Case i of
    0: begin
         RecList.Clear;
         if Memo1.Lines.Count > 0 then begin
           For x:= 0 to Memo1.Lines.Count-1 do RecList.Add(Memo1.Lines[x]);
         end; 
         Memo2.Lines.Clear;
         IIDList.Clear;
         if KeyList.Count > 0 then begin
           IdxAnzahl:= 0;
           For x:= 0 to KeyList.Count-1 do begin
             ListText:= KeyList[x];
             LText:= Uppercase(ListText);
             Strip(LText);
             Memo2.Lines.Add(Listtext);
             if Pos('KEYNO=',LText) > 0 then begin
               Inc(IdxAnzahl);
               Str(IdxAnzahl,IStr);
               L:= 0;
               if Pos('KEYLEN',LText) > 0 then begin
                 LStr:= LText;
                 Delete(LStr,1,Pos('KEYLEN',LStr)+6);
                 if LStr[1] = '=' then Delete(LStr,1,1);
                 if Pos('}',LStr) > 0 then begin
                   LStr:= Copy(LStr,1,Pos('}',LStr)-1);
                   Val(LStr,L,Code);
                 end;
               end;
               Str(L,LStr);
               if Pos('TRUE',LText) > 0 then IIDList.Add('IID['+IStr+'].KeyL:= '+LStr+'; IID['+IStr+'].AllowDupK:= TRUE;')
               else IIDList.Add('IID['+IStr+'].KeyL:= '+LStr+'; IID['+IStr+'].AllowDupK:= FALSE;');
             end;
           end;
         end
         else Memo2.Lines.Add('F(Feldname,0);');
         Memo3.Lines.Clear;
         if IIDList.Count > 0 then begin
           For x:= 0 to IIDList.Count-1 do Memo3.Lines.Add(IIDList[x]);
         end
         else Memo3.Lines.Add('IID[1].KeyL:= 0; IID[1].AllowDupK:= FALSE;');
       end;
    1: begin
         KeyList.Clear;
         if Memo2.Lines.Count > 0 then begin
           KeyList.Add('(*{KEY BEGIN}');
           idxAnzahl:= 0;
           For x:= 0 to Memo2.Lines.Count-1 do begin
             KStr:= Memo2.Lines[x];
             if (Pos('KEY BEGIN',KStr) = 0) and (Pos('KEY END',KStr) = 0) then begin
               Inc(IdxAnzahl);
               if (Pos('S:=',KStr) = 0) then KStr:= 'S:='+KStr;
               xPos:= Pos('{KEYNO=',KStr);
               if xPos > 0 then begin
                 Delete(KStr,xPos,7);
                 While (Length(KStr) > xPos) and (KStr[xPos] <> '}') do Delete(KStr,xPos,1);
                 if KStr[xPos] = '}' then Delete(KStr,xPos,1);
               end;
               KStr:= KStr + '{KEYNO='+DezStr(IdxAnzahl)+'}';
               KeyList.Add(KStr);
             end;
           end;
           KeyList.Add('{KEY END}*)');
         end;
         IIDList.Clear;
         if Memo3.Lines.Count > 0 then begin
           For x:= 0 to Memo3.Lines.Count-1 do begin
             IIDList.Add(Memo3.Lines[x]);
             Check_KeyList(Memo3.Lines[x],KeyList);
           end;
         end;
       end;
  end;
end;

procedure TIsamMainForm.VorBttnClick(Sender: TObject);
var i: Integer;
begin
  i:= Notebook1.PageIndex;
  Case i of
    0: begin
         Update_Listen(0);
         I:= 1;
       end;
    1: begin
         Update_Listen(1);
         i:= 2;
       end;
    2: i:= 3;
    3: i:= 4;
    4: i:= 5;
    5: ModalResult:= mrOk;
    6: ModalResult:= mrOk;
  end;
  Notebook1.PageIndex:= i;
  CheckButtons;
end;

procedure TIsamMainForm.EdiHauptCheckClick(Sender: TObject);
begin
  if EdiHauptCheck.Checked then BrwHauptCheck.Checked:= False;
end;

procedure TIsamMainForm.BrwHauptCheckClick(Sender: TObject);
begin
  if BrwHauptCheck.Checked then EdiHauptCheck.Checked:= False;
end;

procedure TIsamMainForm.SpeedButton1Click(Sender: TObject);
var Txt: String;
begin
  if SaveDialog1.Execute then begin
    Txt:= SaveDialog1.FileName;
    While Pos('\',Txt) > 0 do Delete(Txt,1,Pos('\',Txt));
    if Pos('.',Txt) > 0 then Txt:= Copy(Txt,1,Pos('.',Txt)-1);
    Edit1.Text:= Txt;
    {if EditorFormNameInput.Text = '' then} begin
      EditorFormNameInput.Text:= Txt + 'Dialog';
    end;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.SpeedButton3Click(Sender: TObject);
var Txt: String;
begin
  if SaveDialog1.Execute then begin
    Txt:= SaveDialog1.FileName;
    While Pos('\',Txt) > 0 do Delete(Txt,1,Pos('\',Txt));
    if Pos('.',Txt) > 0 then Txt:= Copy(Txt,1,Pos('.',Txt)-1);
    Edit3.Text:= Txt;
    if BrwFormNameInput.Text = '' then begin
      BrwFormNameInput.Text:= Txt + 'Dialog';
    end;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.SpeedButton4Click(Sender: TObject);
begin
  DirAuswahlDlg:= TDirAuswahlDlg.Create(Self);
  Try
    if Sprache = 1 then DirAuswahlDlg.Caption:= 'Select path';
    if DirAuswahlDlg.ShowModal = mrOk then
    DirInput.Text:= DirAuswahlDlg.DirectoryListbox1.Directory+'\';
  Finally
    DirauswahlDlg.Free;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.SpeedButton5Click(Sender: TObject);
begin
  if FontDialog1.Execute then EdiFontLabel.Font:= FontDialog1.Font;
end;

procedure TIsamMainForm.SpeedButton6Click(Sender: TObject);
begin
  if FontDialog1.Execute then EdiInputFontLabel.Font:= FontDialog1.Font;
end;

procedure TIsamMainForm.SpeedButton7Click(Sender: TObject);
begin
  if FontDialog1.Execute then LboxFontLabel.Font:= FontDialog1.Font;
end;

procedure TIsamMainForm.Memo1Exit(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.HelpBttnClick(Sender: TObject);
begin
  if Sprache = 1 then Application.HelpFile:= 'EXPTISAE.HLP'
  else Application.HelpFile := 'EXPTISAM.HLP';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TIsamMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = vk_F1 then HelpBttnClick(Sender);
end;

Procedure TIsamMainForm.Setze_Sprache(S: Integer);
begin
  Case Sprache of
    1: begin
         CancelBttn.Caption:= '&Cancel';
         CancelBttn.Hint:= 'Cancel';
         Rueckbttn.Caption:= '&Back';
         RueckBttn.Hint:= 'Back';
         VorBttn.Caption:= '&Forward';
         VorBttn.Hint:= 'Forward';
         GroupBox2.Caption:= 'Editor Options';
         EdiHauptCheck.Caption:= 'Editor as main window';
         GroupBox4.Caption:= 'Browser Options';
         BrwHauptCheck.Caption:= 'Browser as main window';
         FileopenBttn.Hint:= 'Load file *.TYP';
         GroupBox5.Caption:= 'Path and Filenames';
         Label7.Caption:= 'Filename (without EXT)';
         BrwCheck.Caption:= 'create';
         EdiCheck.Caption:= 'create';
         StruCheck.Caption:= 'create';
         Groupbox13.Caption:= 'Structure';
         SpeedButton1.Hint:= 'Select Editor-FileName';
         SpeedButton3.Hint:= 'Select Browser-FileName';
         Label9.Caption:= 'Path-Name';
         SpeedButton4.Hint:= 'Select path';
         Label10.Caption:= 'INI-Filename';
         Label11.Caption:= 'INI-Browsername';
         GroupBox6.Caption:= 'Labels and Inputlines';
         LabelNebenRadio.Caption:= 'side by side';
         LabelueberRadio.Caption:= 'beneath';
         GroupBox7.Caption:= 'Input-length';
         LenFestRadio.Caption:= 'fixed';
         LenVarRadio.Caption:= 'variable';
         SpeedButton5.Hint:= 'Select Label-Font';
         SpeedButton6.Hint:= 'Select Input-Font';
         SpeedButton7.Hint:= 'Select Browser-Font';
         Label2.Caption:= 'Table';
         HelpBttn.Caption:= '&Help';
         HelpBttn.Hint:= 'Help';
         SprachBttn.Caption:= '&German';
         SprachBttn.Hint:= 'Deutsche Sprache auswhlen';
         DateiBttn.Hint:= 'Select ISAM-table';
         DbStruBttn.Hint:= 'filename of the DBASE-structure file';
       end;
    else begin
         CancelBttn.Caption:= 'Abbruch';
         CancelBttn.Hint:= 'Abbruch';
         Rueckbttn.Caption:= '&Zurck';
         RueckBttn.Hint:= 'Zurck';
         VorBttn.Caption:= '&Weiter';
         VorBttn.Hint:= 'Weiter';
         GroupBox2.Caption:= 'Editor Einstellungen';
         EdiHauptCheck.Caption:= 'Editor als Hauptfenster';
         GroupBox4.Caption:= 'Browser Einstellungen';
         BrwHauptCheck.Caption:= 'Browser als Hauptfenster';
         FileopenBttn.Hint:= 'TYP-Datei laden';
         GroupBox5.Caption:= 'Pfad and Dateinamen';
         Label7.Caption:= 'Dateiname (ohne EXT)';
         BrwCheck.Caption:= 'create';
         EdiCheck.Caption:= 'create';
         StruCheck.Caption:= 'create';
         Groupbox13.Caption:= 'Structure';
         SpeedButton1.Hint:= 'Editor-Sourcefilenamen auswhlen';
         SpeedButton3.Hint:= 'Browser-Sourcefilenamen auswhlen';
         Label9.Caption:= 'Ziel-Verzeichnis';
         SpeedButton4.Hint:= 'Pfad auswhlen';
         Label10.Caption:= 'INI-Dateiname';
         Label11.Caption:= 'INI-Browsername';
         GroupBox6.Caption:= 'Labels und Inputlines';
         LabelNebenRadio.Caption:= 'nebeneinander';
         LabelueberRadio.Caption:= 'untereinander';
         GroupBox7.Caption:= 'Input-Lnge';
         LenFestRadio.Caption:= 'fest';
         LenVarRadio.Caption:= 'variabel';
         SpeedButton5.Hint:= 'Label-Font auswhlen';
         SpeedButton6.Hint:= 'Input-Font auswhlen';
         SpeedButton7.Hint:= 'Browser-Font auswhlen';
         Label2.Caption:= 'Tabelle';
         HelpBttn.Caption:= '&Hilfe';
         HelpBttn.Hint:= 'Help';
         SprachBttn.Caption:= '&English';
         SprachBttn.Hint:= 'Select english language';
         DateiBttn.Hint:= 'Isam-Tabelle auswhlen';
         DbStruBttn.Hint:= 'Filename der DBASE-Struktur-Datei';
       end;
  end;
end;

procedure TIsamMainForm.FormShow(Sender: TObject);
begin
  if Sprache <> 0 then Setze_Sprache(Sprache);
end;

procedure TIsamMainForm.SprachBttnClick(Sender: TObject);
begin
  if Sprache = 0 then Sprache:= 1 else Sprache:= 0;
  Setze_Sprache(Sprache);
end;

procedure TIsamMainForm.DateiBttnClick(Sender: TObject);
begin
  if OpenDialog2.Execute then begin
    TableNameInput.Text:= OpenDialog2.FileName;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.Edit1Exit(Sender: TObject);
begin
  if EditorFormNameInput.Text = '' then begin
    EditorFormNameInput.Text:= Edit1.Text + 'Dialog';
  end;
  CheckButtons;
end;

procedure TIsamMainForm.Edit3Exit(Sender: TObject);
begin
  if BrwFormNameInput.Text = '' then begin
    BrwFormNameInput.Text:= Edit3.Text + 'Dialog';
  end;
  CheckButtons;
end;

procedure TIsamMainForm.EditorFormNameInputExit(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.BrwFormNameInputExit(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.TableNameInputExit(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.DirInputExit(Sender: TObject);
begin
  CheckButtons;
  if Edit1.Text = '' then edit1.Text := 'Edi';
  if edit3.Text = '' then Edit3.Text := 'Bro';
  if DBStruEdit.Text = '' then DBStruEdit.Text := 'Stru';
end;

procedure TIsamMainForm.DBaseExpCheckClick(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.DBaseImpCheckClick(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.DBStruEditExit(Sender: TObject);
var Txt: String;
begin
  Txt:= DbStruEdit.Text;
  if Pos('.',Txt) > 0 then Txt:= Copy(Txt,1,Pos('.',Txt)-1);
  CheckButtons;
end;

procedure TIsamMainForm.DBStruBttnClick(Sender: TObject);
var Txt: String;
begin
  if SaveDialog1.Execute then begin
    Txt:= SaveDialog1.FileName;
    While Pos('\',Txt) > 0 do Delete(Txt,1,Pos('\',Txt));
    if Pos('.',Txt) > 0 then Txt:= Copy(Txt,1,Pos('.',Txt)-1);
    DBStruEdit.Text:= Txt;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then begin
    Key := #0;
    Perform(WM_NEXTDLGCTL, 0, 0);
  end;
end;

procedure TIsamMainForm.SaveTypBttnClick(Sender: TObject);
var TypDatei: TextFile;
    I       : Integer;
    Txt     : String;
begin
  SaveDialog2.FileName:= TypDateiName;
  if SaveDialog2.Execute then begin
    TypDateiName:= SaveDialog2.FileName;
    if TypDateiName <> '' then begin
      AssignFile(TypDatei,TypDateiName);
      Rewrite(TypDatei);
      Writeln(TYPDATEI,'{TableName = '+TableNameInput.Text+'}');
      Writeln(TYPDATEI,'{EditorFormName = '+EditorFormNameInput.Text+'}');
      Writeln(TYPDATEI,'{EditorUnitName = '+Edit1.Text + '}');
      Writeln(TYPDATEI,'{BrowserFormName = '+BrwFormNameInput.Text+'}');
      Writeln(TYPDATEI,'{BrowserUnitName = '+Edit3.Text + '}');
      Writeln(TYPDATEI,'{StruUnitName = '+DBStruEdit.Text +'}');
      Writeln(TYPDATEI,'{DestPath = '+DirInput.Text+'}');
      Writeln(TYPDATEI,'{ALIASNAME = '+AliasEdit.Text+'}');
      if RecList.Count > 0 then begin
        For i:= 0 to RecList.Count-1 do begin
          Txt:= Reclist[i];
          Writeln(TypDatei,Txt);
        end;
      end;
      if KeyList.Count > 0 then begin
        For i:= 0 to KeyList.Count-1 do begin
          Txt:= Keylist[i];
          Writeln(TypDatei,Txt);
        end;
      end;
      CloseFile(TypDatei);
    end;
  end;
end;

procedure TIsamMainForm.AliasEditClick(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.SpeedButton8Click(Sender: TObject);
begin
  OpenDialog3.Title:= 'Browser-Prototyp';
  if OpenDialog3.Execute then BrwProtoEdit.Text:= OpenDialog3.FileName;
  CheckButtons;
end;

procedure TIsamMainForm.SpeedButton9Click(Sender: TObject);
begin
  OpenDialog3.Title:= 'Editor-Prototyp';
  if OpenDialog3.Execute then EdiProtoEdit.Text:= OpenDialog3.FileName;
  CheckButtons;
end;

procedure TIsamMainForm.BrwCheckClick(Sender: TObject);
begin
  if BrwCheck.Checked then begin
    BrwUpdCheck.Checked:= False;
    FrmBrwUpdcheck.Checked:= False;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.BrwUpdCheckClick(Sender: TObject);
begin
  if (BrwUpdCheck.Checked) or (FrmBrwUpdCheck.Checked)
  then BrwCheck.Checked:= False;
  CheckButtons;
end;

procedure TIsamMainForm.EdiUpdCheckClick(Sender: TObject);
begin
  if (EdiUpdCheck.Checked) or (FrmEdiUpdCheck.Checked)
  then EdiCheck.Checked:= False;
  CheckButtons;
end;

procedure TIsamMainForm.BrwAllBttnClick(Sender: TObject);
var i: Integer;
begin
  if Listbox1.Items.Count > 0 then begin
    For i:= 0 to Listbox1.Items.Count-1 do begin
      Listbox1.Selected[i]:= True;
    end;
  end;
  CheckButtons;
end;

procedure TIsamMainForm.EdiAllBttnClick(Sender: TObject);
var i: Integer;
begin
  if Listbox2.Items.Count > 0 then begin
    For i:= 0 to Listbox2.Items.Count-1 do begin
      Listbox2.Selected[i]:= True;
    end;
  end;
  Checkbuttons;
end;

procedure TIsamMainForm.UpdOldBtnClick(Sender: TObject);
begin
  Notebook1.PageIndex:= 6;
  CheckButtons;
end;

procedure TIsamMainForm.ListBox1Click(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.ListBox2Click(Sender: TObject);
begin
  Checkbuttons;
end;

procedure TIsamMainForm.BrwProcUpdCheckClick(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.EdiProcUpdcheckClick(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.AendernBttnClick(Sender: TObject);
begin
  NeuerAendernBttn:= not(NeuerAendernBttn);
  if NeuerAendernBttn then begin
    AendernBttn.Glyph.Handle:= LoadBitmap(HInstance,'IS_CHANGE');
    AendernBttn.NumGlyphs:= 2;
  end
  else begin
    AendernBttn.Glyph.Handle:= LoadBitmap(HInstance,'IS_AENDERN');
    AendernBttn.NumGlyphs:= 1;
  end;
end;

procedure TIsamMainForm.SDBEditChange(Sender: TObject);
begin
  CheckButtons;
end;

procedure TIsamMainForm.IDBEditChange(Sender: TObject);
begin
  CheckButtons;
end;

end.
